/**
* \file: ald.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: authorization level daemon
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef ALD_CONTROL_ALD_H
#define ALD_CONTROL_ALD_H

#include <stdbool.h>
#include "ald_types.h"

typedef void (*callback_func_t)(void);

error_code_t ald_init(int argc, char *argv[]);

error_code_t ald_mainloop(void);

void ald_shutdown(void);

void ald_deinit(void);

void ald_activate_challenge_timeout(void);

void ald_deactivate_challenge_timeout(void);

void ald_activate_script_exec_timeout(void);

void ald_deactivate_script_exec_timeout(void);

void ald_request_daemon_exit_due_to_errors(error_code_t error);

void ald_die_on_resource_issues(void);

#endif
